function [m_x, m_fx, m_a, m_fa] = vsecant(strF, x, a, etol, x0, varargin),

% VSECANT Apply the secant method.
%
% VSECANT(strF, x, a, etol, x0, ... ).  strF is a string defining the 
% function to call.  (x, a) is the interval, etol is the tolerance 
% level, x0 is a matrix of arguments that change depending on the 
% surface called.  Extra arguments to the objective function can be 
% included. 
%
% NOTE : 
%  assumes that (f(x), f(a)) are finite.
% 
x = x(:); a=a(:);

nd  = (1:length(x))';

% finite (a, b) and (f(a), f(b))
fx = feval(strF, x, x0, varargin{:});
fa = feval(strF, a, x0, varargin{:});

cnt = 0;
while(cnt < 100),
    
    % current best guess is a nan or not complex?
    i = isnan(fx)|(~isreal(fx));
    if (any(i)), 
        m_fx(nd(i)) = nan;
        m_x(nd(i))  = x(i);
        m_fa(nd(i)) = fa(i);
        m_a(nd(i))  = a(i);
        
        if (all(i)),
            % return here 
            m_x  = m_x(:);
            m_fx = m_fx(:);
            m_a  = m_a(:);
            m_fa = m_fa(:);
            return
        end 
                
        % reduce 
        i = ~i;
        fx = fx(i);
        x  = x(i);
        fa = fa(i);
        a  = a(i);
        x0 = x0(i,:);
        nd = nd(i); 
    end 
    
    % current guess is acceptable  
    i = (abs(fx) < etol);
    if (any(i)),
        m_x(nd(i))  = x(i);
        m_fx(nd(i)) = fx(i);
        m_a(nd(i))  = a(i);
        m_fa(nd(i)) = fa(i);
 
        if (all(i)), 
            % return here 
            m_x  = m_x(:);
            m_fx = m_fx(:);
            m_a = m_a(:);
            m_fa = m_fa(:);           
%           fprintf('RETURN.\n');
%           keyboard;
            return 
        end 

        % reduce 
        i  = ~i;
        fx = fx(i);
        x  = x(i);
        fa = fa(i);
        a  = a(i);
        x0 = x0(i,:);
        nd = nd(i);
    end 
    
    % SECANT STEP 
    % 
    % (a, fa) becomes current (x, fx)  
    % (x, fx) is updated to best estimate. 
    % 
    
    xc  = x;
    fxc = fx;        
    dx = -fa.*((a-x)./(fa-fx));
    x  = a + dx;
    fx = feval(strF, x, x0, varargin{:});
    
    a   = xc;
    fa  = fxc;
    cnt = cnt + 1;
end 
    
return