function [m_x, m_f] = vgolden(f, a, b, eps, phi, varargin)

% VGOLDEN vectorized golden section search. 
%
% VGOLDEN(fn, a, b, eps, phi, ...).  Apply golden section 
% minimization search over interval [a, b], to tolerance eps. 
% The phi matrix are optional parameters for the vectorized 
% objective function. Additional parameters on the command line 
% will be passed to the objective function.
%
% Example 
%
%
% NOTE : 
%
%   Adapted from lecture notes at :  
%   http://www.math.uic.edu/~jan/mcs471/Lec9/gss.pdf
%   


[f,msg] = fcnchk(f);
if  ~isempty(msg)
    error(msg)
end

% intial (golden section) guesses 
c = (-1+sqrt(5))/2;
x1 = c*a + (1-c)*b;  
fx1 = feval(f, x1, phi, varargin{:});
x2 = (1-c)*a + c*b;   
fx2 = feval(f, x2, phi, varargin{:});

% intialize 
nd = 1:length(a); nd = nd(:);
m_x = nd*0; 
m_f = m_x;

cnt = 0;
while(cnt < 500),
    
    i = fx1 < fx2;
    if any(i),
        b(i) = x2(i);
        x2(i) = x1(i);
        fx2(i) = fx1(i);
        x1(i) = c*a(i) + (1-c)*b(i);
        fx1(i) = feval(f,x1(i),phi(i,:),varargin{:});
    end

    i = ~i;
    if any(i),
        a(i) = x1(i);
        x1(i) = x2(i);
        fx1(i) = fx2(i);
        x2(i) = (1-c)*a(i) + c*b(i);
        fx2(i) = feval(f,x2(i),phi(i,:),varargin{:});
    end

    i = abs(b-a) < eps/2;
    if (any(i)),
        m_x(nd(i)) = 0.5*(a(i)+b(i));
        m_f(nd(i)) = feval(f,m_x(nd(i)),phi(i,:),varargin{:});
        if (all(i)),
            return
        end
        
        % get remaining 
        i = ~i;
        a = a(i); b = b(i);
        x1 = x1(i); x2 = x2(i);
        fx1 = fx1(i); fx2 = fx2(i);
        phi = phi(i,:);
        nd = nd(i);
    end 
    
    cnt = cnt + 1;
end

error('(VGOLDEN) Exceeded count.');