function C = vcross(A,B),

% VCROSS return cross product of rows of two [nx3] matrices. 
% i.e., an [nx3] matrix C with row n given by, cross(A(n,:), B(n,:))
%


C(:,1) = A(:,2).*B(:,3) - A(:,3).*B(:,2);
C(:,2) = -(A(:,1).*B(:,3) - A(:,3).*B(:,1));
C(:,3) = A(:,1).*B(:,2) - A(:,2).*B(:,1);

return
