function [m_b, m_fb, exitflag, output] = vbrent(FunFcnIn, a, b, etol, phi, varargin)

%VBRENT  Scalar nonlinear zero finding (parallelized). 
%   X = VBRENT(fun, a, b, etol, phi, ...) tries to find a zero of the function FUN near X0. 
%   FUN accepts real scalar input X and returns a real scalar function value F 
%   evaluated at X.  The value X returned by FZERO is near a point where FUN 
%   changes sign (if FUN is continuous), or NaN if the search fails.  
%
% where 
%       FunFcnIn = Function name  
%       in       = [ a b ] intevral 
%       phi      = additional parameters 
%
%  PHI is a matrix, each row is data for each parallel optimization.
% 
% Notes : 
%
% 20/7 return nanned intervals 
% 27/7 tolerance variable not passed in - hard-coded only. 

%   Copyright 1984-2002 The MathWorks, Inc. 
%   $Revision: 5.33 $  $Date: 2002/04/08 20:26:46 $

%  This algorithm was originated by T. Dekker.  An Algol 60 version,
%  with some improvements, is given by Richard Brent in "Algorithms for
%  Minimization Without Derivatives", Prentice-Hall, 1973.  A Fortran
%  version is in Forsythe, Malcolm and Moler, "Computer Methods
%  for Mathematical Computations", Prentice-Hall, 1976.

% Initialization
fcount = 0;
exitflag = 1;

% defaultopt = struct('Display','notify','TolX',eps);
% % tol = optimget(options,'TolX',defaultopt,'fast');
% % If just 'defaults' passed in, return the default options in X
% if nargin==1 & nargout <= 1 & isequal(FunFcnIn,'defaults')
%    b = defaultopt;
%    return
% end

% Note: don't send varargin in as a comma separated list!!
% numargin = nargin; numargout = nargout;
% [tol, trace, calltype, FunFcn, varargin] = ...
%   parse_call(FunFcnIn,x,defaultopt,numargin,numargout,varargin);

FunFcn = FunFcnIn;
tol = 1e-9;

% --------------------
% scalar input for x.
% --------------------

    [FunFcn,msg] = fcnchk(FunFcn);
    if  ~isempty(msg)
        error(msg)
    end
    
   % enter test intervals
%   a = in(:,1);
%   b = in(:,2);
 
   c = 0*a;
   e = c; s = c; p = c; q = c; d = c; r = c;
   
   fa = feval(FunFcn, a, phi, varargin{:});
   fb = feval(FunFcn, b, phi, varargin{:});
   
   nd = (1:length(a)); nd = nd(:);
   
   % main algorithm  
   fc = fb;
   
   % Main loop, exit from middle of the loop
   while (1),

    % b is the best result so far, 
    % a is the previous value of b
    % c is on the opposite of the zero from b.
   
    i = ((fb >0) == (fc>0));
   
    if (any(i)), 
       c(i) = a(i); fc(i) = fa(i);
       d(i) = b(i) - a(i); e(i) = d(i);
   end
      
   % swap so b is the best 
   i = (abs(fc) < abs(fb));
   if any(i),
      a(i) = b(i);    b(i) = c(i);    c(i) = a(i);
      fa(i) = fb(i);  fb(i) = fc(i);  fc(i) = fa(i);
   end
   
   % Convergence test and possible exit
   m = 0.5*(c - b);
   toler = 2.0*tol*max(abs(b),1.0);

   i = (abs(m) <= toler) | (fb == 0.0);
   if any(i), 
       
      m_b(nd(i))    = b(i);    
      m_c(nd(i))    = c(i);
      m_fb(nd(i))   = fb(i);
      m_fc(nd(i))   = fc(i);
            
      if (all(i)),
        % return through here
        m_b    = m_b(:);    
        m_c    = m_c(:);
        m_fb   = m_fb(:);
        m_fc   = m_fc(:);
        break    
      end
      
      % reduce
      i = ~i;
      
      nd = nd(i);
      
      a  = a(i);
      b  = b(i);
      c  = c(i);
      d  = d(i);

      e  = e(i);
      fa = fa(i);
      fb = fb(i);
      fc = fc(i);
      toler = toler(i);
      
      p = p(i);
      q = q(i);
      m = m(i);

      phi = phi(i,:);
      
  end
   
   % Choose bisection or interpolation
   i = (abs(e) < toler) | (abs(fa) <= abs(fb));
 
   % bisection 
   if   (any(i)),
        d(i) = m(i);
        e(i) = m(i);
   end

   % interpolation
   if   (any(~i)),
      i = ~i;
      s(i) = fb(i)./fa(i);
      i0 = (a == c)&i;
      if    (any(i0)),
            % Linear interpolation
            p(i0) = 2.0*m(i0).*s(i0);
            q(i0) = 1.0 - s(i0);
      end
      
      i0  = (a ~= c)&i;
      if (any(i0)),
            % Inverse quadratic interpolation
            q(i0) = fa(i0)./fc(i0);
            r(i0) = fb(i0)./fc(i0);
            p(i0) = s(i0).*(2.0*m(i0).*q(i0).*(q(i0) - r(i0)) - (b(i0) - a(i0)).*(r(i0) - 1.0));
            q(i0) = (q(i0) - 1.0).*(r(i0) - 1.0).*(s(i0) - 1.0);
      end
   
      % switch-a-roo
      i0 = (p > 0)&i;
      if (any(i0&i)),
          q(i0) = - q(i0);
      end
     
      i0 = (p <= 0)&i;
      if (any(i0)),
          p(i0) = - p(i0);
      end
     
      % Is interpolated point acceptable
      i1 = (2.0*p < 3.0*m.*q - abs(toler.*q)) & (p < abs(0.5*e.*q));
      i0 = i1&i;
      if (any(i0)), 
         e(i0) = d(i0);  
         d(i0) = p(i0)./q(i0);
      end 
             
      i0 = (~i1)&i;
      if (any(i0)),
         d(i0) = m(i0);  
         e(i0) = m(i0);
      end;
    
   end  % Interpolation
      
   % Next point
   a    = b;
   fa   = fb;
   i    = (abs(d) > toler);
   if (any(i)), 
       b(i) = b(i) + d(i);
   end 

   if (any(~i)), 
        i = ~i;
        i0    = (b > c)&i;
        if (any(i0)), 
            b(i0) = b(i0) - toler(i0);
        end 
        
        i0    = (b <= c)&i;
        if (any(i0)), 
            b(i0) = b(i0) + toler(i0);
        end 
   end
    
   fb = feval(FunFcn, b,phi,varargin{:});
   fcount = fcount + 1;      
   
end % Main loop

return