function [m_a, m_b, m_fa, m_fb] = vbracket(strF, a, b, phi, varargin),

% VBRACKET Return finite brackets.
%
% VBRACKET(strF, a, b, phi, ...).  The function is defined in 
% strF, (a,b) is a nominal bracket, phi is a matrix that can 
% be modified as process carries on.  The additional arguments 
% are passed as additional arguments. 
% 

nd = (1:length(a))';
cnt = 0;

% one bracket is crook
while (cnt < 100),

    fa = feval(strF, a, phi, varargin{:});
    fb = feval(strF, b, phi, varargin{:});

    % irreperable brackets
    i = (~isfinite(fa))&(~isfinite(fb));
    if (any(i)),
        m_a(nd(i))  = a(i); 
        m_fa(nd(i)) = nan;
        m_b(nd(i))  = b(i); 
        m_fb(nd(i)) = nan;
    
        if (all(i)),
            return
        end

        % remaining 
        i = ~i; nd = nd(i);
        a = a(i); b = b(i);
        fa = fa(i); fb = fb(i);
        phi = phi(i,:);
    end

    % good brackets
    i = isfinite(fa)&isfinite(fb);
    if (any(i)),
        m_a(nd(i))  = a(i); 
        m_fa(nd(i)) = fa(i);
        m_b(nd(i))  = b(i); 
        m_fb(nd(i)) = fb(i);
        
        if (all(i)),
            return
        end

        % remaining 
        i = ~i; nd = nd(i);
        a = a(i); b = b(i);
        fa = fa(i); fb = fb(i);
        phi = phi(i,:);
    end

    
    i = ~isfinite(a)&~isfinite(b);
    if (any(i)),
        m_a(nd(i))  = a(i); 
        m_fa(nd(i)) = nan;
        m_b(nd(i))  = b(i); 
        m_fb(nd(i)) = nan;
        if (all(i)),
            return
        end 
        % remaining 
        i = ~i; nd = nd(i);
        a = a(i); b = b(i);
        fa = fa(i); fb = fb(i);
        phi = phi(i,:);
    end
    
    % bisection step
    i = (~isfinite(a))&isfinite(b);
    if (any(i)), % advance left bracket
        a(i) = (b(i)+a(i))/2;
     end
    
    i = (isfinite(a))&(~isfinite(b));
    if (any(i)), % advance right bracket
        b(i) = (a(i)+b(i))/2;
    end

    cnt = cnt + 1;
    
end

error('(VBRACKET) Exceeded maximum iterations.');

return
