function n = rmse(x),

% RMSE = norm(x)/sqrt(n)
% X is a matrix.  Norm n elements in X.
% This finds RMSE of x-matrix, using median value from the x-matrix to compute errors.
% 
% RMSE = sqrt (sum (error(i)^2)) / sqrt(n)
% General solution for error calculated between original and fitted data,
% where error(i) = origdata(i) - fitteddata(i)
% 
% Error= x-y
% does element-by-element subtraction of vectors, where error, x, and y are all vectors of same length.
% 
% by Jennifer Yoon, 11/25/2003


n = length(x);
n = norm(x)/sqrt(n);

return