function [a, b] = mesh3vec(a, b);

% MESHVEC get all combinations of the two matrices 
% A and B where size(A)=[N,3] and size(B)=[M,3]. Returns
% an [MxN,3] matrix. 
%

[ Sx, Tx ]  = meshgrid(a(:, 1), b(:, 1));
[ Sy, Ty ]  = meshgrid(a(:, 2), b(:, 2));
[ Sz, Tz ]  = meshgrid(a(:, 3), b(:, 3));

a = []; b = [];

a(:,1) = Sx(:); b(:,1) = Tx(:);
a(:,2) = Sy(:); b(:,2) = Ty(:);
a(:,3) = Sz(:); b(:,3) = Tz(:);

return 