function nVec = getrotvec(nVec, nRotMtx, nOrigin),

% GETROTVEC rotate a rays object in the x-y-z sense
% 
% GETROTVEC(nVec, nRotMtx). Rotate the ray and angle nAng about 
% the origin [0 0 0]. nAng is [tx, ty, tz] in radians.
% 
% GETROTVEC(nVec, nRotMtx, nOrigin). Rotate the ray and angle nAng about 
% the origin nOrigin. nAng is [tx, ty, tz] in radians.
% 

if (nargin == 3),
    nOrigin = nOrigin(ones([ size(nVec, 1) 1]),:);
    nVec = nVec - nOrigin;
    nVec = nVec*(nRotMtx');
    nVec = nVec + nOrigin;
elseif (nargin == 2),
    nVec = nVec*(nRotMtx');
end

return


