function R = getRotMtx(nType, nAlpha),

% GETROTMTX return rotation matrix for
% the reuested angle about the requested axis
% 
% R = GETROTMTX(nType, nAlpha). Get rotation matrices.
% use radian measure nAlpha.  
%
% R = GETROTMTX(nType, nAlpha). Get rotation matrices.
% use radian measure nAlpha.  
%
% use http://en.wikipedia.org/wiki/Rotation_matrix
%
%       [  cos(thz) -sin(thz) 0  ]
% Rz =  [  sin(thz)  cos(thz) 0  ]
%       [    0         0      1  ]
% 
%       [  cos(thy)  0  sin(thy) ]
% Ry =  [     0      1    0      ]
%       [  -sin(thy) 0  cos(thy) ]
% 
%       [  1     0         0       ]
% Rx =  [  0   cos(thx) -sin(thx)  ]
%       [  0   sin(thx)  cos(thx)  ]
%
% 'zyx'  Rz*Ry*Rx


if (nargin == 1), 
    nAlpha = nType;
    nType  = 'xyz'; 
end 

switch lower(nType)
   case 'z',
     R = [ cos(nAlpha) -sin(nAlpha) 0 ; sin(nAlpha) cos(nAlpha) 0 ; 0 0 1 ];
     % R = [ cos(nAlpha) sin(nAlpha) 0 ; -sin(nAlpha) cos(nAlpha) 0 ; 0 0 1 ];
   case 'y',
     % R = [ cos(nAlpha) 0 -sin(nAlpha) ; 0 1 0 ; sin(nAlpha) 0 cos(nAlpha) ];
     R = [ cos(nAlpha) 0 sin(nAlpha) ; 0 1 0 ; -sin(nAlpha) 0 cos(nAlpha) ];
   case 'x',
     R = [ 1 0 0 ; 0 cos(nAlpha) -sin(nAlpha) ; 0 sin(nAlpha) cos(nAlpha) ];
   case 'zyx'
      R = getRotMtx('z',nAlpha(3))*getRotMtx('y',nAlpha(2))*getRotMtx('x',nAlpha(1));
   otherwise
     error('(GETROTMTX) Unknown rotation matrix requested.');
end
return