function [k, strList] = getProperty(strVar, strList, pDefVal),

% GETPROPERTY Return the property and value pair from the cell array 
%
% [pVal, strList] = GETPROPERTY(strVar, strList, pDefVal).  Here 
% strVar is the required  variable, strList is a cell array and pDefVal 
% is the default value if that variable does not exist.  Note that 
% the function returns strList without the property required.
%

  if (isempty(strList)),
      k = pDefVal;
      return
  end
  
  try, 
    cprops = strList(1:2:end);
    cval   = strList(2:2:end);
  catch
    fprintf('(GETPROPERTY) Malformed property list (property, value, ...)\n');  
    rethrow(lasterror);  
  end

  nprops = length(cprops);
  l = strcmp(strVar, cprops);
  
  if (any(l)),
      
      % duplicate property
      if (sum(l) > 1),
         error('(GETPROPERTY) Duplicate property.'); 
      end
      
      % return the property and remainder list
      k    = find(l);
      if   (k == 1),
            k = cval{1};
            if (nprops == 1),
                strList = []; 
            else, % (nprops > 1),
                strList = strList(3:end); 
            end
            return
      elseif (k == nprops),
            k = cval{nprops};
            strList = strList(1:(end-2));  
            return
      end
      
      % k between (1, nprops).
      k         = cval{l};
      strList   = { strList{1:(2*(k-1))} strList{(2*k+1):end} };
      return
  end
  
  k = pDefVal;
return