function y = getNumDv(f, x, y, strF, varargin),

% GETNUMDV Get a numerically computed derivative function. 
%
% GETNUMDV(f, x, y, strF, ...). Here f is a string defining the 
% function to call. (x,y) are a position, strF is the required 
% derivative, and additional arguments to the surface can be 
% included at the end.

dx = 1e-5;
switch(strF),
    case { 'dzdx' }
        y = (feval(f, x+dx, y, varargin{:}) - feval(f, x-dx, y, varargin{:}))/(2*dx);
    case { 'dzdy' }
        y = (feval(f, x, y+dx, varargin{:}) - feval(f, x, y-dx, varargin{:}))/(2*dx);
    otherwise,
        error('(GETNUMDV) Unknown derivative requested.');
end
return
