function Z = dpol2dcar(phi,R,HPHI,HR, flg)

% DPOL2DCAR convert polar representation to cartesian representation
% 
% Z = dpol2dcar(phi,R,HPHI,HR,myflag) 
% 
% where   Z       is the requested derivative
%         phi     is the angle of the point (in radians)
%         R       is the radius of the point
%         HPHI    is the angular derivative
%         HR      is the radial derivative
%         myflag  'dzdx' 'dzdy' 'normal'

% x derivative
I = find(R>0);

% disp([ 'Entered dpol2dcar ... ' flg ]);

switch flg

   case { 'dzdx','u',1 }

        HX = zeros(size(phi));  
        HX(I) = (-sin(phi(I)).*HPHI(I))./R(I) + cos(phi(I)).*HR(I);
        Z  = HX;

   case { 'dzdy','v',2 }
	
        HY = zeros(size(phi));   
        HY(I) = (cos(phi(I)).*HPHI(I))./R(I) + sin(phi(I)).*HR(I);
        Z = HY;

   case { 'normal',3 }
  
        HX = zeros(size(phi));  
        HX(I) = (-sin(phi(I)).*HPHI(I))./R(I) + cos(phi(I)).*HR(I);
  
        HY = zeros(size(phi));   
        HY(I) = (cos(phi(I)).*HPHI(I))./R(I) + sin(phi(I)).*HR(I);
   
        Z = [ HX HY HX*0-1 ];
   
   otherwise
    disp('error: miscdir/dpol2dcar.m  unspecified behaviour');
   
end

return
