function Z = dcar2dpol(X,Y,HX,HY,myflag)

% DCAR2DPOL.M convert the cartesian derivatives into 
% polar coordinate derivatives 
% 
% function Z = dcar2dpol(X,Y,HX,HY,myflag)
% 
% myflag = 'dzdt' w.r.t. phi
%        = 'dzdr' w.r.t. r


% added 19/10/03 - return a structure

if (nargin == 4)
   [ T R ]  = cart2pol(X,Y);
   Z.fr = cos(T).*HX + sin(T).*HY;
   Z.fphi = -Y.*HX+X.*HY;
   return
end


switch myflag
  
  case { 'dzdt',1 }
  HPHI = -Y.*HX+X.*HY;
  Z  = HPHI;
  
  case { 'dzdr',2 }
   [ T R ]  = cart2pol(X,Y);
   HR = cos(T).*HX + sin(T).*HY; 
   Z  = HR;

  otherwise
  disp('error: miscdir/dcar2dpol.m unspecified behaviour');
   
end


return
