function Y = c_lsq(A2,B2,A1,B1),

% ------------------------------------------
% 
% C_LSQ  constrained least squares
% do a least squares fit on the data
% 
% function A22 = c_lsq(A2,B2,A1,B1),
% 
% 
% A1*X = B1  constraint equations:
% A2*X = B2  least squares equation:
% 
% find the solution to the equation,
% 
%  AX = B
% 
% where A = [ A1 ; A2 ] 
%       B = [ B1 ; B2 ]
% 


% A2 = [ 1 2 5 4 ; 1 -1 2 3 ; 3 4 -1 2 ; 5 3 6 -3 ; 7 6 5 2 ];
% B2 = [ 4 ; 5 ; 6; -1 ; 7 ];
% A1 = [ 4 1 -1 2 ];
% B1 = 3;

% produce reduced matrix system (parameter elimination)
[ A B k ] = c_aug(A2,B2,A1,B1);

% A
% B
% constrained system


% solve this system in the least squares sense
X = A\B;

% k
% A1

if (length(k) == 1)
    
    % only 1 constraint present
    R       = eye(length(X));
    A1_elim = c_elimcol(A1,k);                  % get the row without the k^th column
    R       = c_rowins(R,-A1_elim/A1(k),k);     % produce a basis for the range of A!
    Z       = zeros(size(A2,2),1);
    Z(k)    = B1/A1(k);
    Y       = Z + R*X;                          % restored matrix    

else

    disp('warning: 2 or more constraints present - unavailable');    

end

return


  
if exist('A1'),
   
    % one interpolation constraint at a time for now anyways!!
    [ A B ] = caug(A1,b1,el_param,A2,B2);
        
    % disp('remove the zero columns');
    I    = ~any(A); % 1 on columns with zeros/ 0 on columns that are non-zero             
    if   any(I),
      
         disp('columns to remove');      
         AA   = A(:,find(I)); BB = B;
         A22t = AA\BB;
         X    = zeros([ 1 size(A,2) ]);
         X(I) = A22t;
         X    = X';
       
         % disp('zeroed the columns');
         % size(AA)
         % size(A)
         %  size(BB)
         % size(X)
         % input('wait...');
         
    else 
       
         % the long way
         X    = A\B;  
    end

    disp('augmented decomissioned for present time.');
    X1 = A\B; X = X1;
        
    
    disp('interpolation check')
    disp('should be the same when columns are zero in both cases');
    disp('------------------------------------------------------')
    [sum(full(X(I))-full(X1(I))) ]
%   input('wait...');
    
    
    % remove the parameter from original constraint equations
    % A11 if the constraint matrix minus the constraint 
    n   = size(A1,2);
    BT  = A1(:,(el_param+1):n);
    A11 = A1; A11(:,el_param:(n-1)) = BT;
    A11 = A11(:,1:(n-1));

    % This is the lost parameter
    % c(n) = 1/(a(n)) * (b1 - A11*X)
    a1      = A1(el_param);
    m       = (1/a1)*(b1 - A11*X);
    
    % rebuild the control point matrix
    c                       = length(X);
    A22                     = [ X ; 0 ];
    A22((el_param+1):(c+1)) = X((el_param):c);
    A22(el_param)           = m;
    
    % disp('check for ');
    % input('wait.');
    
else
    
    % return the least squares approximation
    A = A2;
    B = B2;
        
    I    = sum(abs(A)); I  = (I ~= 0);
    if   ~isempty(I),
         AA = A(:,find(I));
         BB = B;
         A22t = AA\BB;
         A22    = zeros([ 1 size(A,2) ]);
         A22(I) = A22t;
         A22    = A22';    
    else
         A22       = A\B;   
    end
            
end


return




% SOME GRAPHING ROUTINES ---------------------------

x1 =-7:1:7;
y1 = m.*x1 + (c+x1*0);

clf;
hold on;
plot(x,y,'+');
plot(x1,y1,'r-');

% check
disp('constraint match?');
y1 = A1*[ m ; c ]
B1
