function [ A, B, k, A1, B1 ] = c_aug(A2,B2,A1,B1),

% C_AUG parameter elimination of the least squares  
% equation, eliminating the ncol^th column.
% 
% function [new_A2, new_B2] = c_aug(A2,B2,A1,B1)
%
% eliminate the ncol column
%
% least squares equation:
%   A2*X = B2
% 
% constraint equation:
%   A1*X = B1
% 
% 
% return the augmented matrix
% which hopefully has incorporated
% the reduction constraint!
% 

A   = A2;
B   = B2;
k   = [];


A1_temp = A1;


for j = 1:size(A1,1),

    % eliminate the largest non-zero parameter from the constraint
    [d,ncol] = max(abs(A1(j,:)));
    [d,k(j)] = max(abs(A1_temp(j,:))); % original indexes eliminated
    
    % parameter elimination 
    [A,B]   = c_augline(A,B,ncol,A1(j,:),B1(j,:));      % eliminate from main matrix
    [A1,B1] = c_augline(A1,B1,ncol,A1(j,:),B1(j,:));    % eliminate from constraint equation
       
end


return


%
% A1 & B1 are row vector and scalar only 
%

function [ new_A2, new_B2 ] = c_augline(A2,B2,ncol,A1,B1),
    
    % take the column corresponding to the (ncol)^th column of A2 (the least squares matrix)
    A2_ncol = A2(:,ncol);           % take the ncol column of the least squares equation
    alpha   = A2_ncol/A1(ncol);     % scale factors that will zero the A2 columns when A1*alpha is added

    % multiply each row of the constraint equation by alpha
    %y1      = alpha(:,ones([ 1 size(A2,2) ]))
    %y2      = A1(ones([ size(A2,1) 1]),:)
    new_A2  = alpha(:,ones([ 1 size(A2,2) ])) .* A1(ones([ size(A2,1) 1]),:);  % repeated columns
    new_B2  = alpha .* B1(ones([size(A2,1) 1]));                
    
    % there should be a zero'ed column
    new_A2 = A2 - new_A2;
    new_B2 = B2 - new_B2;
    
    new_A2  = c_elimcol(new_A2, ncol);
    
return
