function a = acorr2(a)

% ACORR2. 2-D Auto-correlation by way of the FFT 
%
% ACORR2(a). 
%
% where 
%       a is MxN matrix 
%
% minimal padding strategy - consistent with XCORR2. 
% could do with a padding optimation (2^X).

%% (C) 2004 Jason Turuwhenua 
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%% C = xcorr2 (A)

% minimum size
n = 2*size(a,2)-1;
m = 2*size(a,1)-1;

a = fft2(a,m,n);
a = a .* conj(a);
a = ifft2(a,m,n);
a = fftshift(a);

% a = abs(a);

return