function [ nTX, nTY ] = Vec2EulerYX(nVec),

% VEC2EULYX Vector to Euler Rotation YX, i.e., ignoring   
% rotation about the Z axis (for the sake of simplicity).
%
% [nTX, nTY ] = VEC2EULYX(nVec).  Here nVec is a row vector 
% to convert to rotation about X axis, followed by rotation
% nTY about the Y axis. 
% 
% This is applied to a rotationally symmetric surface, in 
% which 

nVec = vunit(nVec); 
nTX  = -asin(nVec(:,2));
nTY  = acos(nVec(:,3)./cos(nTX));

% R      = getRotMtx('zyx', [ nTX nTY 0 ]); 
return 